/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.item.data;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.setup.registry.AddonDataComponentRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.Vec3;

public record ExplorationScrollData(Optional<HolderSet<Structure>> structure, Optional<Vec3> pos, int searchRadius, boolean skipKnownStructures) {
    public static final TagKey<Structure> DEFAULT_DESTINATION = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ArsAdditions.prefix("on_explorer_warp_scroll"));
    public static final int DEFAULT_SEARCH_RADIUS = 50;
    public static final boolean DEFAULT_SKIP_EXISTING = true;
    public static final Codec<ExplorationScrollData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.STRUCTURE).optionalFieldOf("structure").forGetter(ExplorationScrollData::structure), (App)Vec3.CODEC.optionalFieldOf("pos").forGetter(ExplorationScrollData::pos), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("search_radius", (Object)50).forGetter(ExplorationScrollData::searchRadius), (App)Codec.BOOL.optionalFieldOf("skip_existing_chunks", (Object)true).forGetter(ExplorationScrollData::skipKnownStructures)).apply((Applicative)inst, ExplorationScrollData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ExplorationScrollData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.holderSet((ResourceKey)Registries.STRUCTURE)), ExplorationScrollData::structure, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.fromCodec((Codec)Vec3.CODEC)), ExplorationScrollData::pos, (StreamCodec)ByteBufCodecs.INT, ExplorationScrollData::searchRadius, (StreamCodec)ByteBufCodecs.BOOL, ExplorationScrollData::skipKnownStructures, ExplorationScrollData::new);

    public static ExplorationScrollData fromItemStack(ItemStack stack) {
        return (ExplorationScrollData)stack.getOrDefault(AddonDataComponentRegistry.EXPLORATION_SCROLL_DATA, (Object)new ExplorationScrollData(Optional.empty(), Optional.empty(), 50, true));
    }
}

